/** @file   DatafileItem.cpp
 * @brief   Implementation of DatafileItem class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/02/21 20:48:11 $
 * @author  Tomi Lamminsaari
 */

#include "DatafileContainer.h"
#include "Allegro.h"

namespace eng2d {

///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
DatafileContainer::DatafileContainer() :
  GraphicsContainer( EUnspecified ),
  iDatafile( 0 ),
  iDatafileObjectCount( 0 )
{
}



/** Destructor.
 */
DatafileContainer::~DatafileContainer()
{
  this->ResetAndDestroy();
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Clears the contents.
 */
void DatafileContainer::ResetAndDestroy()
{
  if ( iDatafile != 0 ) {
    unload_datafile( iDatafile );
    iDatafile = 0;
  }
}



/** Not in use.
 */
void DatafileContainer::Push( void* aItem )
{
}


/** Returns the item with given uid.
 */
void* DatafileContainer::At( int aUid ) const
{
  if ( aUid < 0 || aUid >= iDatafileObjectCount || iDatafile == 0 ) {
    return 0;
  }
  return iDatafile[aUid].dat;
}


///
/// New public methods
/// ============================================================================

/** Sets the datafile.
 */
void DatafileContainer::SetDatafile( DATAFILE* aDatafile )
{
  this->ResetAndDestroy();
  iDatafile = aDatafile;
  iDatafileObjectCount = 0;
  while ( true ) {
    if ( iDatafile[iDatafileObjectCount].dat == 0 ) {
      break;
    }
    iDatafileObjectCount += 1;
  }
}




///
/// Getter methods
/// ============================================================================

/** Returns a bitmap.
 */
BITMAP* DatafileContainer::GetBitmap( int aIndex ) const throw( xOutOfBounds,
                                                                xLogicError )
{
  if ( aIndex < 0 || aIndex >= iDatafileObjectCount || iDatafile == 0 ) {
    throw xOutOfBounds( "DatafileItem", "GetBitmap(int)" );
  }
  
  if ( iDatafile[aIndex].type != DAT_BITMAP ) {
    throw xLogicError( "DatafileItem",
                       "GetBitmap(int)",
                       "Datafile content type mismatch" );
  }
  return reinterpret_cast<BITMAP*>( iDatafile[aIndex].dat );
}



/** Returns a rle sprite.
 */
RLE_SPRITE* DatafileContainer::GetRleSprite( int aIndex ) const throw ( xOutOfBounds,
                                                                        xLogicError )
{
  if ( aIndex < 0 || aIndex >= iDatafileObjectCount || iDatafile == 0 ) {
    throw xOutOfBounds( "DatafileItem", "GetBitmap(int)" );
  }
  if ( iDatafile[aIndex].type != DAT_RLE_SPRITE ) {
    throw xLogicError( "DatafileItem",
                       "GetRleSprite(int)",
                       "Datafile content type mismatch" );
  }
  return reinterpret_cast<RLE_SPRITE*>( iDatafile[aIndex].dat );
}




///
/// Protected and private methods
/// ============================================================================


};  // end of namespace
